#Start

library(ggplot2)
library(readxl)
library(reshape2)
library(Rmisc)
library(dplyr)
library(naniar)
library(carData)
library(plyr)

#Definition du thème graphique
theme_custom <- function() {
  theme(
    plot.title = element_text(color = "black", size = 20, face = "bold", hjust = 0.5), 
    legend.text = element_text(size=15), axis.text = element_text(size=12),axis.title = element_text(size = 15, face = "bold"),
    panel.background = element_rect(fill="transparent"), plot.background = element_rect(fill = "transparent", color=NA),
    panel.grid.major = element_blank(), panel.grid.minor = element_blank(), axis.line.x = element_line(size = 2), axis.line.y = element_line(size = 2)
    
  )
}

#Change workdir
setwd("~/Library/Mobile Documents/com~apple~CloudDocs/LCAMB/Microscopie fluorescence/Confocal/HEK P2Xs 1 - 7 1µM + Inhibitieur/Analyse")
getwd()

#Charger les données excel

#P2X7
data <- as.data.frame(sapply(read_excel("P2X7.xlsx"), as.numeric))

#Calcul des backgrounds par serie
background <- aggregate(Background ~ Serie, data = data, FUN = mean)

#Calculer le CTCF pour chaque sous-série en soustrayant le background de cette particulière série

x = 1
P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
P2X7 <- as.data.frame(CF)
for (x in 2:50)
{
  P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
  CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
  P2X7 <- rbind(P2X7, CF)
}
rename(P2X$Area )

#AZ10606120
data <- as.data.frame(sapply(read_excel("AZ10606120.xlsx"), as.numeric))

#Calcul des backgrounds par serie
background <- aggregate(Background ~ Serie, data = data, FUN = mean)

#Calculer le CTCF pour chaque sous-série en soustrayant le background de cette particulière série

x = 1
P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
AZ10606120 <- as.data.frame(CF)
for (x in 2:50)
{
  P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
  CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
  AZ10606120 <- rbind(AZ10606120, CF)
}
rename(P2X$Area )

#A740003
data <- as.data.frame(sapply(read_excel("A740003.xlsx"), as.numeric))

#Calcul des backgrounds par serie
background <- aggregate(Background ~ Serie, data = data, FUN = mean)

#Calculer le CTCF pour chaque sous-série en soustrayant le background de cette particulière série

x = 1
P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
A740003 <- as.data.frame(CF)
for (x in 2:50)
{
  P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
  CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
  A740003 <- rbind(A740003, CF)
}
rename(P2X$Area )

#Change workdir
setwd("~/Library/Mobile Documents/com~apple~CloudDocs/LCAMB/Microscopie fluorescence/Confocal/HEK P2Xs 1 - 7 1µM + Inhibitieur/Analyse")
getwd()

#P2X1
data <- as.data.frame(sapply(read_excel("P2X1.xlsx"), as.numeric))

#Calcul des backgrounds par serie
background <- aggregate(Background ~ Serie, data = data, FUN = mean)

#Calculer le CTCF pour chaque sous-série en soustrayant le background de cette particulière série

x = 1
P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
P2X1 <- as.data.frame(CF)
for (x in 2:50)
{
  P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
  CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
  P2X1 <- rbind(P2X1, CF)
}
rename(P2X$Area )

#P2X2
data <- as.data.frame(sapply(read_excel("P2X2.xlsx"), as.numeric))

#Calcul des backgrounds par serie
background <- aggregate(Background ~ Serie, data = data, FUN = mean)

#Calculer le CTCF pour chaque sous-série en soustrayant le background de cette particulière série

x = 1
P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
P2X2 <- as.data.frame(CF)
for (x in 2:50)
{
  P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
  CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
  P2X2 <- rbind(P2X2, CF)
}
rename(P2X$Area )

#P2X3
data <- as.data.frame(sapply(read_excel("P2X3.xlsx"), as.numeric))

#Calcul des backgrounds par serie
background <- aggregate(Background ~ Serie, data = data, FUN = mean)

#Calculer le CTCF pour chaque sous-série en soustrayant le background de cette particulière série

x = 1
P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
P2X3 <- as.data.frame(CF)
for (x in 2:50)
{
  P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
  CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
  P2X3 <- rbind(P2X3, CF)
}
rename(P2X$Area )

#P2X4
data <- as.data.frame(sapply(read_excel("P2X4.xlsx"), as.numeric))

#Calcul des backgrounds par serie
background <- aggregate(Background ~ Serie, data = data, FUN = mean)

#Calculer le CTCF pour chaque sous-série en soustrayant le background de cette particulière série

x = 1
P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
P2X4 <- as.data.frame(CF)
for (x in 2:50)
{
  P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
  CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
  P2X4 <- rbind(P2X4, CF)
}
rename(P2X$Area )

#P2X5
data <- as.data.frame(sapply(read_excel("P2X5.xlsx"), as.numeric))

#Calcul des backgrounds par serie
background <- aggregate(Background ~ Serie, data = data, FUN = mean)

#Calculer le CTCF pour chaque sous-série en soustrayant le background de cette particulière série

x = 1
P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
P2X5 <- as.data.frame(CF)
for (x in 2:50)
{
  P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
  CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
  P2X5 <- rbind(P2X5, CF)
}
rename(P2X$Area )

#P2X6
data <- as.data.frame(sapply(read_excel("P2X6.xlsx"), as.numeric))

#Calcul des backgrounds par serie
background <- aggregate(Background ~ Serie, data = data, FUN = mean)

#Calculer le CTCF pour chaque sous-série en soustrayant le background de cette particulière série

x = 1
P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
P2X6 <- as.data.frame(CF)
for (x in 2:50)
{
  P2X <- subset(data, Serie==x, select = c("Area", "Mean"))
  CF = as.data.frame(P2X$Mean - background$Background[Serie = x])
  P2X6 <- rbind(P2X6, CF)
}
rename(P2X$Area )


#Calcul statistiques

t.test(P2X1, P2X2)


#Renom les colonnes des data parce que j'ai codé ça comme un sagoin


names(P2X7)[names(P2X7) == "P2X$Mean - background$Background[Serie = x]"] <- "P2X7"
names(AZ10606120)[names(AZ10606120) == "P2X$Mean - background$Background[Serie = x]"] <- "AZ10606120"
names(A740003)[names(A740003) == "P2X$Mean - background$Background[Serie = x]"] <- "A740003"
names(P2X1)[names(P2X1) == "P2X$Mean - background$Background[Serie = x]"] <- "P2X1"
names(P2X2)[names(P2X2) == "P2X$Mean - background$Background[Serie = x]"] <- "P2X2"
names(P2X3)[names(P2X3) == "P2X$Mean - background$Background[Serie = x]"] <- "P2X3"
names(P2X4)[names(P2X4) == "P2X$Mean - background$Background[Serie = x]"] <- "P2X4"
names(P2X5)[names(P2X5) == "P2X$Mean - background$Background[Serie = x]"] <- "P2X5"
names(P2X6)[names(P2X6) == "P2X$Mean - background$Background[Serie = x]"] <- "P2X6"






#Representation graphique de toutes les conditions

total <- rbind.fill(P2X7, AZ10606120, A740003, P2X1, P2X2, P2X3, P2X4, P2X5, P2X6)

total_long <- melt(total, id.vars=c("P2X7", "AZ10606120", "A740003","P2X1", "P2X2", "P2X3", "P2X4", "P2X5", "P2X6"), 
                   measure.vars=c("P2X7", "AZ10606120", "A740003","P2X1", "P2X2", "P2X3", "P2X4", "P2X5", "P2X6"),
                   variable.name = "recepteur",
                   value.name = "CF")

total_sum <- summarySE(total_long,
                       measurevar = "CF",
                       groupvars = "recepteur",
                       na.rm = TRUE)
total_sum


graphbar <- ggplot(total_sum, aes(x = recepteur, y = CF)) +
  geom_bar(stat = 'identity', position = position_dodge(), size=2, fill = "white", colour = "black") +
  geom_errorbar(aes(ymin = CF, ymax = CF + sd), width = 0.1, na.rm=TRUE, position = position_dodge(0.1), size=2) +
  geom_jitter(data = total_long, width = 0.1, height = 0.1, size = 2)
graphbar

final_bar <- graphbar + labs(title="Membrane labelling of transfected HEK cells", x="Receptor", y="CF", size= 2) +
  theme_custom() +
  theme(axis.line = element_line(color="black", size = 1))

final_bar
